// name_hash.cpp
// This program creates a simple "hash" of
// a person's name. A hash is an integer that is
// mathematically derived from another object.
// In this case, a string (the first and last name)
// is accessed character by character and the hash
// is built up from a number generated by each character.
// While this function does not necessarily produce
// unique hashes (different names can hash to the
// same value), there is a relatively low possibility
// of a "collision" with a class of roughly 400 students.
//
// We will learn more about hashing later this quarter!

#include <iostream>
#include <string>
#include "console.h"
#include "simpio.h"  // for getLine
using namespace std;

// function definition
int nameHash(string first, string last);

// function bodies
int main() {
    string first, last;
    int hashValue;

    first = getLine("What is your first name? ");
    last = getLine("What is your last name? ");

    hashValue = nameHash(first, last);

    cout << "The hash of your name is: " << hashValue << endl;
    return 0;
}

int nameHash(string first, string last){
    string full = first+last; // concatenated
    static int P = 16908799; // a big prime number
    int hashVal = 0;
    for (char c : full) {
        // only use lowercase letters
        c = tolower(c);
        hashVal = (127 * hashVal + c) % P;
    }
    return hashVal;
}
